		/***********************************************
		*
		*	음원재생 Javascript 
		*  2012.08.07
		*  최인혁 차장
		*
		************************************************/
		var players;
		var rePrc = null;
		var onSoundDiv = 0;
		function playerReady(thePlayer) { 
			try{						
				players.addEventListener("ended",function(e){
					rePrc = 'ended';
					$('.p_play_pause').css('background' , 'url("../../Img/smart/p_play.png") no-repeat');
					closeSound();
				});
				players.addEventListener("pause",function(e){
					rePrc = 'pause';
					$('.p_play_pause').css('background' , 'url("../../Img/smart/p_play.png") no-repeat');
				});	
				players.addEventListener("stop",function(e){
					rePrc = 'stop';
					$('.p_play_pause').css('background' , 'url("../../Img/smart/p_play.png") no-repeat');
					closeSound();
				});
				players.addEventListener("play",function(e){
					rePrc = 'play';
					$('.p_play_pause').css('background' , 'url("../../Img/smart/p_pause.png") no-repeat');
				});
			}catch(e){
				setTimeout("playerReady('1')", 100);
			}
		}
		

		function openPlayer(event , f, num)
		{
			
			var openChk = false;
			if(num == onSoundDiv)
			{
				openChk = true;
			}
			if(onSoundDiv > 0)
			{
				players.stop();	
			}
			
			var pleft = (layout_width - 112) / 2;
		
			$('#sound_div').css('left',   pleft+"px");
			$('#sound_div').css('top',  "150px");
			$('#sound_div').css('display', 'block');

			if(!openChk)
			{	
				players = new Audio(f); 	
				players.play();
				playerReady('1');
				
				onSoundDiv = num;
			}
			
		}
		function loadMp3(f)
		{
			try{
				players.sendEvent("LOAD",f);
				playMp3();
			}catch(e){		
				setTimeout("loadMp3('"+f+"');",100);
			}
		}

		function playMp3()
		{
			try{
				players.sendEvent("PLAY", true);
				addEventMp3();
			}catch(e){
				setTimeout("playMp3();",100);
			}
		}

		function addEventMp3()
		{
			try{

				players.addControllerListener("STOP", "closeSound");
			}catch(e){
				setTimeout("addEventMp3();",100);
			}
		}

		function closeSound()
		{
			onSoundDiv = 0;
			$('#sound_div').css('display', 'none');
		}

		function pauseSound() 
		{
			if(rePrc == 'stop' || rePrc == 'ended' || rePrc =='pause') {
				try{players.play();}catch(e){}
			}
			if(rePrc == 'play') {
				try{players.pause();}catch(e){}
			}
		}
		function stopSound() {
			pauseSound();
			closeSound();
			try{players.load();}catch(e){}
		}